@extends('layouts.master')

@section('title')
    Detail Anggota
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Detail Anggota</li>
@endsection

@section('content')
<form action="{{ route('member.updated_detail', $member->id_member) }}" class="form" id="forms" style="width:100%;" method="post">
    @csrf
    @method('PUT')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            {{-- <button onclick="window.print()">Print this page</button> --}}
            <div class="box-header with-border">
                <h4>PROFIL ANGGOTA</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                        <th>Nama Lengkap</th>
                        <th>Tempat Tanggal Lahir</th>
                        <th>Alamat Rumah</th>
                        <th>Telepon</th>
                        <th>Telepon Darurat</th>
                        {{-- <th>Tanggal Masuk</th> --}}

                        
                    </thead>
                    <tbody>
                        <td>{{$member->nama}}</td>
                        <td>{{$member->ttl}}</td>
                        <td>{{$member->alamat}}</td>
                        <td>{{$member->telepon}}</td>
                        <td>{{$member->telepon_darurat}}</td>
                        {{-- <td>{{$member->tgl_masuk}}</td> --}}
                    </tbody>
                    <thead>
                        <th>Nomer KTP</th>
                        <th>Jenis Kelamin</th>
                        <th>Alamat Kantor</th>
                        <th>Email</th>
                        <th>Sosmed</th>
                        {{-- <th>Tanggal Berakhir</th> --}}
                    </thead>
                    <tbody>
                        <td>{{$member->no_ktp}}</td>
                        <td>{{$member->gender}}</td>
                        <td>{{$member->alamat_kantor}}</td>
                        <td>{{$member->email}}</td>
                        <td>{{$member->sosmed}}</td>
                        {{-- <td>{{$member->exp_date}}</td> --}}
                    </tbody>
                </table>
                
            </div>
        </div>
    </div>
</div>



<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <h4>DETAIL MEMBERSHIP</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                        <th>Nama Paket Membership</th>
                        <th>Harga Paket</th>    
                    </thead>
                    <tbody>
                        <td>{{$member->nama_paket}}</td>
                        <td>@currency($member->harga)</td>
                    </tbody>
                    <thead>
                         <th>Tanggal Masuk</th>
                        <th>Tanggal Berakhir</th>
                    </thead>
                    <tbody>
                        <td>{{$member->tgl_masuk}}</td>
                        <td>{{$member->exp_date}}</td>
                    </tbody>
                </table>
                
            </div>
        </div>
    </div>
</div>




<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <h4>DETAIL PERSONAL TRAINER</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                       <th>Nama Paket</th>
                       <th>Harga</th>
                       <th>Nama Personal Trainer</th>
                    </thead>
                    <tbody>
                        <td>{{$member->nama_paket2}}</td>
                        <td>@currency($member->harga2)</td>
                        <td>{{$member->id_instruktur}}</td>
                    </tbody>
                    <thead>
                        <th>Tanggal Masuk</th>
                        <th>Tanggal Berakhir</th> 
                    </thead>
                    <tbody>  
                        <td>{{$member->tgl_masuk2}}</td>
                         <td>{{$member->exp_date2}}</td>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>




<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <h4>DETAIL PEMBAYARAN</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                       <th>Biaya Admin</th>
                       <th>Biaya Lain-lain</th>
                       <th>Total Keseluruhan</th>
                    </thead>
                    <tbody>
                        <td>@currency($member->biaya_admin)</td>
                        <td>@currency($member->biaya_lainnya)</td>
                        <td>@currency($member->total)</td>
                    </tbody>
                    <thead>
                        <th>Tanggal Pembayaran</th>
                        <th>Jenis Pembayaran</th> 
                        <th>Nama Staff</th> 
                    </thead>
                    <tbody>  
                        <td>{{$member->tanggal_bayar2}}</td>
                         <td>{{$member->jenis_pembayaran_pribadi}}</td>
                         <td>{{$member->role}}</td>
                    </tbody>
                     
                </table>
            </div>
        </div>
    </div>
</div>

    <div class="row">
        <div class="col-lg-12">
            <div class="box">
                <div class="box-header with-border">
                    <h4>CATATAN</h4>
                </div>
                <div class="box-body table-responsive">
                    <table class="table table-stiped table-bordered table-penjualan">
                    
                        <textarea name="catatan" id="" cols="153" rows="5">{{$member->catatan}}</textarea>
                        </table>
                        <button type="submit" class="btn btn-info pull-right">Simpan</button>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection
 
  
  
 
